/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.entity;

import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import dev.onyxstudios.cca.api.v3.entity.PlayerCopyCallback;
import dev.onyxstudios.cca.api.v3.entity.PlayerSyncCallback;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import dev.onyxstudios.cca.api.v3.entity.TrackingStartCallback;
import dev.onyxstudios.cca.internal.entity.SwitchablePlayerEntity;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class CardinalComponentsEntity {
    public static final class_2960 PACKET_ID = new class_2960("cardinal-components", "entity_sync");

    public static void init() {
        if (FabricLoader.getInstance().isModLoaded("fabric-networking-api-v1")) {
            PlayerSyncCallback.EVENT.register(player -> CardinalComponentsEntity.syncEntityComponents(player, (class_1297)player));
            TrackingStartCallback.EVENT.register(CardinalComponentsEntity::syncEntityComponents);
        }
        PlayerCopyCallback.EVENT.register(CardinalComponentsEntity::copyData);
    }

    private static void copyData(class_3222 original, class_3222 clone, boolean lossless) {
        boolean keepInventory = original.field_6002.method_8450().method_8355(class_1928.field_19389) || clone.method_7325();
        Set keys = original.getComponentContainer().keys();
        for (ComponentKey key : keys) {
            CardinalComponentsEntity.copyData(original, clone, lossless, keepInventory, key, !((SwitchablePlayerEntity)original).cca$isSwitchingCharacter());
        }
    }

    private static <C extends Component> void copyData(class_3222 original, class_3222 clone, boolean lossless, boolean keepInventory, ComponentKey<C> key, boolean sameCharacter) {
        Component from = key.get((Object)original);
        Component to = key.get((Object)clone);
        RespawnCopyStrategy.get(key).copyForRespawn(from, to, lossless, keepInventory, sameCharacter);
    }

    private static void syncEntityComponents(class_3222 player, class_1297 tracked) {
        class_1297 provider = tracked;
        for (ComponentKey key : provider.getComponentContainer().keys()) {
            key.syncWith(player, (ComponentProvider)provider);
        }
    }
}

